<?php
include_once 'db.php';

// Fetch the orderids parameter from the URL
$orderIdsRaw = $_GET['orderids'] ?? '';

// Sanitize and validate the order IDs
$orderIdsArray = explode(',', $orderIdsRaw);
$sanitizedOrderIds = array_map('intval', $orderIdsArray);
$sanitizedOrderIds = array_filter($sanitizedOrderIds, 'is_numeric');

if (empty($sanitizedOrderIds)) {
    die('No valid order IDs provided.');
}

$pdfContents = [];

foreach ($sanitizedOrderIds as $orderId) {
    // Fetch invoice details
    $query = mysqli_query($connection, "SELECT * FROM orders WHERE id = '$orderId'");
    if (!$query) {
        die('Query failed: ' . mysqli_error($connection));
    }
    
    $invoice = mysqli_fetch_array($query);  
    if (!$invoice) {
        die('No invoice found for order ID: ' . $orderId);
    }

    // Fetch customer details
    $customerid = $invoice['customerid'];
    $grandtotal = $invoice['grandtotal'];
    $orderdate = $invoice['createdate']; // Assuming this is the order date
    $customerquery = mysqli_query($connection, "SELECT * FROM customer WHERE id='$customerid'");
    if (!$customerquery) {
        die('Query failed: ' . mysqli_error($connection));
    }
    
    $customerfetch = mysqli_fetch_array($customerquery);
    if (!$customerfetch) {
        die('No customer found for ID: ' . $customerid);
    }

    $displayname = $customerfetch['displayname'];
    $address = $customerfetch['address'];
    $city = $customerfetch['city'];
    $pincode = $customerfetch['pincode'];
    $email = $customerfetch['email'];
    $phoneno = $customerfetch['phoneno'];

    // Fetch profile details for logo
    $qs = "SELECT * FROM profile WHERE 1=1";
    $results = $connection->query($qs);
    if (!$results) {
        die('Query failed: ' . mysqli_error($connection));
    }
    
    $rows = mysqli_fetch_array($results);
    if (!$rows) {
        die('No profile found.');
    }
    
    $logopath = $rows['logopath'];

    // Generate HTML for the invoice
    $output = '
    <!DOCTYPE html>
    <html lang="en">
    <head>
        <meta charset="UTF-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <meta name="description" content="Invoice template">
        <meta name="keywords" content="invoice, receipt, bill">
        <meta name="author" content="initTheme">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <title>Invoice</title>
        <link rel="stylesheet" type="text/css" href="pdfstyle/main-style.css">
        <style>
            body {
                background-color: #F9F9F9;
            }
            .page-break {
                page-break-before: always;
            }
                .terms .headtxt {
            font-size: 15px;
            font-weight: 600;
        }

        .terms p {
            text-align: justify;
        }

        .table1 tr td {
            padding: 5px;
        }

        .table1 {
            width: 100%;
            margin: 0 auto; 
        }

        .table1 td {
            text-align: right;
        }

        .img-container {
            border: 1px solid lightgray;
            width: 100px;
            height: 100px;
            display: flex;
            justify-content: center;
            align-items: center;
            position: relative;
        }

        .img-container img {
            max-width: 100%;
            max-height: 100%;
            object-fit: cover; 
        }

        </style>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/html2pdf.js/0.9.2/html2pdf.bundle.min.js"></script>
        <script>
        document.addEventListener("DOMContentLoaded", function() {
            document.getElementById("bill-download").addEventListener("click", function() {
                var element = document.getElementById("download-section");
                var opt = {
                    margin: [0.5, 0.3, 0.5, 0.3],
                    filename: "invoice.pdf",
                    image: { type: "jpeg", quality: 0.98 },
                    html2canvas: { scale: 2 },
                    jsPDF: { unit: "in", format: "letter", orientation: "portrait" }
                };
                html2pdf().from(element).set(opt).save();
            });
        });
        </script>
         <script>
        $(document).ready(function () {
            var $img = $(".img-container img");
            var $container = $(".img-container");

            function handleImageLoad() {
                if ($img[0].complete && $img[0].naturalWidth === 0) {
                    $container.removeClass("no-border");
                } else {
                    $container.addClass("no-border");
                }
            }

            $img.on("error", function () {
                $container.removeClass("no-border"); 
            });

            $img.on("load", function () {
                $container.addClass("no-border");
            });

            handleImageLoad();
        });
    </script>
    </head>
    <body>
    <main class="container invoice-wrapper">
    <div  id="download-section">
        <div class="invoice-top">
            <div class="row align-items-center">
                <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 text-center text-sm-start mb-3 mb-sm-1">
                    <img src="'.$logopath.'" alt="logo" width="130px">
                </div>
                <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 text-center text-sm-end mb-3 mb-sm-1">
                    <h4 class="text-30 mb-0 mt-0">Order</h4>
                </div>
            </div>
            <hr>
            <div class="row">
                <div class="col-sm-6"><strong>Order Date:</strong> '.date("d/m/Y", strtotime($orderdate)).'</div>
                <div class="col-sm-6 text-sm-end"><strong>Order No:</strong> '.$invoice['orderid'].'</div>
            </div>
            <hr>
        </div>
        <div class="invoice-details border-top mt-20 pt-20">
            <div class="row">
                <div class="col-sm-6 text-sm-end order-sm-1">
                    <strong class="text-18 mb-3 d-inline-block">Pay To:</strong>
                    <address class="mb-4">
                        '.$rows['storename'].'<br>
                        '.$rows['street1'].' '.$rows['street2'].'<br>
                        '.$rows['city'].' - '.$rows['pincode'].'<br>
                        '.$rows['phonenumber'].'
                    </address>
                </div>
                <div class="col-sm-6 order-sm-0">
                    <strong class="text-18 mb-3 d-inline-block">Ordered To:</strong>
                    <address class="mb-4">
                        '.$displayname.'<br>
                        '.$address.'<br>
                        '.$city.' - '.$pincode.'<br>
                        '.$phoneno.'
                    </address>
                </div>
            </div>
        </div>
        <div class="card mb-3">
            <div class="card-body p-0">
                <div class="table-responsive">
                    <table class="table mb-0">
                        <thead class="card-header">
                            <tr>
                                <td class="col-2"><strong>S. No</strong></td>
                                <td class="col-9"><strong>Product Name</strong></td>
                                <td class="col-4"><strong>Qty</strong></td>
                                <td class="col-3 text-center"><strong>MRP</strong></td>
                                <td class="col-3 text-center"><strong>Rate</strong></td>
                                <td class="col-3 text-end"><strong>Disc</strong></td>
                                <td class="col-3 text-end"><strong>Tax</strong></td>
                                <td class="col-3 text-end"><strong>Amount</strong></td>
                            </tr>
                        </thead>
                        <tbody>';

    $count = 0;
    $productsPerPage = 25;

    $sqls = "SELECT * FROM orderdatas WHERE orderid ='$orderId'";
    $sqlexecutes = mysqli_query($connection, $sqls); 
    if (!$sqlexecutes) {
        die('Query failed: ' . mysqli_error($connection));
    }

    $totalSavings = 0;
    foreach($sqlexecutes as $orderrows){
        $count++;
        $productid = $orderrows['productid'];   
        $query2 = mysqli_query($connection, "SELECT * FROM product WHERE id='$productid'");  
        if (!$query2) {
            die('Query failed: ' . mysqli_error($connection));
        }

        $product = mysqli_fetch_array($query2);
        if (!$product) {
            die('No product found for ID: ' . $productid);
        }

        $savings = $orderrows['mrp'] - $orderrows['price'];
        $totalSavings += $savings * $orderrows['qty'];

        $output .= '
        <tr>
            <td class="col-3">'.$count.'</td> 
            <td class="col-3">'.$product['productname'].'</td>  
            <td class="col-4">'.$orderrows['qty'].'</td>  
            <td class="col-2 text-center">'.$orderrows['mrp'].'</td>  
            <td class="col-1 text-center">'.$orderrows['price'].'</td>    
            <td class="col-2 text-end">'.$orderrows['discountvalue'].'</td>  
            <td class="col-2 text-end">'.$orderrows['taxvalue'].'</td>  
            <td class="col-2 text-end">'.$orderrows['producttotal'].'</td>  
        </tr>';

        if ($count % $productsPerPage == 0) {
            $output .= '<tr><td colspan="8" class="page-break"></td></tr>'; 
        }
    }

    $taxquery = "SELECT taxpercentage, SUM(taxvalue) as taxvalue FROM orderdatas WHERE orderid='$orderId' GROUP BY taxpercentage"; 
    $invoicedataquerys = mysqli_query($connection, $taxquery); 
    if (!$invoicedataquerys) {
        die('Query failed: ' . mysqli_error($connection));
    }

    $output .= '
        <tr>
            <td colspan="7" class="text-end"><strong>Total Savings</strong></td>
            <td class="text-end"><strong>'.$totalSavings.'</strong></td>
        </tr>
        <tr>
            <td colspan="7" class="text-end"><strong>Grand Total</strong></td>
            <td class="text-end"><strong>'.$grandtotal.'</strong></td>
        </tr>
        </tbody>
    </table>
    </div>
    </div>
    </div>
    <br>
     <div class="terms">
        <div class="row">
            <div class="col-md-7 text-left">
                <div class="headtxt">Terms & Conditions: </div>
                <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nullam euismod non nisi non pharetra. Pellentesque sapien est, tempus dictum tellus mollis,
                 sodales vestibulum lectus. Vestibulum condimentum id lectus sed euismod.</p>
                <br>
                <div class="headtxt">Notes: </div>
                <p>Duis eu tincidunt ex. Nunc bibendum nunc enim, eu tempus ante porttitor vitae. Praesent gravida eros eu enim varius eleifend.</p>
            </div>
            <div class="col-md-1"></div>
            <div class="col-md-4 text-right" style="display: flex; flex-direction: column; align-items: flex-end;">
            <div class="img-container">
                <img src="images/QR code/qr_code.svg" alt=""/>
            </div>
            <br>
                <table class="table1 text-right">
                    <tr>
                        <td>Account No: </td>
                        <td>98475623546234 </td>
                    </tr>
                    <tr>
                        <td>IFC Code: </td>
                        <td>98475623546234 </td>
                    </tr>
                    <tr>
                        <td>Branch: </td>
                        <td>Trichy </td>
                    </tr>       
                </table>
            </div>
        </div>
    </div>
    </div>
    <div class="text-center mt-5 mb-4 regular-button">
        <div class="d-print-none d-flex justify-content-center flex-wrap gap-10"> 
            <button id="bill-download" class="btn-primary-outline">Download</button> 
            <a href="javascript:window.print()" class="btn-primary-fill">Print Invoice</a> 
        </div>
    </div>




    </main>
    </body>
    </html>';

    $pdfContents[] = $output;
}

echo implode('<div class="page-break"></div>', $pdfContents);
?>
